# Timeline Section

**Version:** 0.1.1
**Content Hash:** f8321cc0530d3b13

## Dependencies

This section requires the following partials:

- [text](../partials/text-v0.1.1.zip)
- [icon](../partials/icon-v0.1.1.zip)
- [commons](../partials/commons-v0.1.1.zip)

**Note:** Dependencies are not included in this package. Download them separately.

## Features

- Includes custom styles

## Installation

### Automated Installation

```bash
./install.sh
```

**Prerequisite:** Create a `nunjucks-components.config.json` file in your project root:

```json
{
  "componentsBasePath": "lib/layouts/components",
  "sectionsDir": "sections",
  "partialsDir": "_partials"
}
```

The install script will:
- Read paths from your config file
- Check for existing versions
- Verify and auto-install dependencies
- Copy files to the correct locations

### Manual Installation

Copy the component files to your project:

```bash
cp timeline.njk your-project/lib/layouts/components/sections/timeline/
cp timeline.css your-project/lib/layouts/components/sections/timeline/
cp manifest.json your-project/lib/layouts/components/sections/timeline/
```

## Usage

Add the timeline section to your page frontmatter:

### Example 1

Configuration from component

```yaml
sections:
  - sectionType: timeline
    containerTag: section
    classes: ''
    id: ''
    isDisabled: false
    containerFields:
      inContainer: true
      isAnimated: true
      noMargin:
        top: false
        bottom: false
      noPadding:
        top: false
        bottom: false
      background:
        color: ''
        image: ''
        imageScreen: none
    text:
      leadIn: ''
      title: Our Journey
      titleTag: h2
      subTitle: Key milestones in our history
      prose: ''
    timeline:
      layout: vertical
      alternating: true
      events:
        - year: '2020'
          title: Company Founded
          description: Started with a vision to transform the industry.
          icon: rocket
        - year: '2021'
          title: First Major Release
          description: Launched our flagship product to market.
          icon: package
        - year: '2022'
          title: Series A Funding
          description: Raised $10M to accelerate growth.
          icon: trending-up
        - year: '2023'
          title: Global Expansion
          description: Opened offices in Europe and Asia.
          icon: globe
        - year: '2024'
          title: 100K Users
          description: Reached a major milestone in user adoption.
          icon: users
```

## More Information

For complete documentation and live examples, visit:
https://nunjucks-components.netlify.app/library/timeline/

