# Team-grid Section

**Version:** 0.1.1
**Content Hash:** 246829c6b007474d

## Dependencies

This section requires the following partials:

- [text](../partials/text-v0.1.1.zip)
- [image](../partials/image-v0.1.1.zip)
- [text-link](../partials/text-link-v0.1.1.zip)
- [commons](../partials/commons-v0.1.1.zip)

**Note:** Dependencies are not included in this package. Download them separately.

## Features

- Includes custom styles
- Includes interactive JavaScript

## Installation

### Automated Installation

```bash
./install.sh
```

**Prerequisite:** Create a `nunjucks-components.config.json` file in your project root:

```json
{
  "componentsBasePath": "lib/layouts/components",
  "sectionsDir": "sections",
  "partialsDir": "_partials"
}
```

The install script will:
- Read paths from your config file
- Check for existing versions
- Verify and auto-install dependencies
- Copy files to the correct locations

### Manual Installation

Copy the component files to your project:

```bash
cp team-grid.njk your-project/lib/layouts/components/sections/team-grid/
cp team-grid.css your-project/lib/layouts/components/sections/team-grid/
cp team-grid.js your-project/lib/layouts/components/sections/team-grid/
cp manifest.json your-project/lib/layouts/components/sections/team-grid/
```

## Usage

Add the team-grid section to your page frontmatter:

### Example 1

Configuration from component

```yaml
sections:
  - sectionType: team-grid
    containerTag: section
    classes: ''
    id: ''
    isDisabled: false
    containerFields:
      inContainer: true
      isAnimated: true
      noMargin:
        top: false
        bottom: false
      noPadding:
        top: false
        bottom: false
      background:
        color: ''
        image: ''
        imageScreen: none
        isDark: false
    text:
      leadIn: ''
      title: Meet Our Team
      titleTag: h2
      subTitle: ''
      prose: The talented people behind our success.
    team:
      source: team-example
      layout: grid
```

## More Information

For complete documentation and live examples, visit:
https://nunjucks-components.netlify.app/library/team-grid/

