# Steps Section

**Version:** 0.1.1
**Content Hash:** 615ae66e83f7fe8d

Display a process or how-it-works section with numbered or icon-based steps

## Dependencies

This section requires the following partials:

- [text](../partials/text-v0.1.1.zip)
- [icon](../partials/icon-v0.1.1.zip)
- [commons](../partials/commons-v0.1.1.zip)

**Note:** Dependencies are not included in this package. Download them separately.

## Features

- Includes custom styles

## Installation

### Automated Installation

```bash
./install.sh
```

**Prerequisite:** Create a `nunjucks-components.config.json` file in your project root:

```json
{
  "componentsBasePath": "lib/layouts/components",
  "sectionsDir": "sections",
  "partialsDir": "_partials"
}
```

The install script will:
- Read paths from your config file
- Check for existing versions
- Verify and auto-install dependencies
- Copy files to the correct locations

### Manual Installation

Copy the component files to your project:

```bash
cp steps.njk your-project/lib/layouts/components/sections/steps/
cp steps.css your-project/lib/layouts/components/sections/steps/
cp manifest.json your-project/lib/layouts/components/sections/steps/
```

## Usage

Add the steps section to your page frontmatter:

### Example 1

Configuration from component

```yaml
sections:
  - sectionType: steps
    containerTag: aside
    classes: ''
    id: ''
    isDisabled: false
    containerFields:
      inContainer: true
      isAnimated: true
      noMargin:
        top: false
        bottom: false
      noPadding:
        top: true
        bottom: false
      background:
        color: ''
        image: ''
        imageScreen: none
    text:
      leadIn: ''
      title: How It Works
      titleTag: h2
      subTitle: Get started in three easy steps
      prose: ''
    steps:
      layout: horizontal
      showNumbers: true
      items:
        - title: Sign Up
          description: Create your free account in seconds. No credit card required.
          icon: user-plus
        - title: Configure
          description: Set up your preferences and connect your integrations.
          icon: settings
        - title: Launch
          description: Go live and start seeing results immediately.
          icon: rocket
```

## More Information

For complete documentation and live examples, visit:
https://nunjucks-components.netlify.app/library/steps/

