# Stats Section

**Version:** 0.1.1
**Content Hash:** ece600fcf84ec91b

Display impact numbers and key metrics in a visually striking grid layout

## Dependencies

This section requires the following partials:

- [text](../partials/text-v0.1.1.zip)
- [icon](../partials/icon-v0.1.1.zip)
- [commons](../partials/commons-v0.1.1.zip)

**Note:** Dependencies are not included in this package. Download them separately.

## Features

- Includes custom styles

## Installation

### Automated Installation

```bash
./install.sh
```

**Prerequisite:** Create a `nunjucks-components.config.json` file in your project root:

```json
{
  "componentsBasePath": "lib/layouts/components",
  "sectionsDir": "sections",
  "partialsDir": "_partials"
}
```

The install script will:
- Read paths from your config file
- Check for existing versions
- Verify and auto-install dependencies
- Copy files to the correct locations

### Manual Installation

Copy the component files to your project:

```bash
cp stats.njk your-project/lib/layouts/components/sections/stats/
cp stats.css your-project/lib/layouts/components/sections/stats/
cp manifest.json your-project/lib/layouts/components/sections/stats/
```

## Usage

Add the stats section to your page frontmatter:

### Example 1

Configuration from component

```yaml
sections:
  - sectionType: stats
    containerTag: aside
    classes: ''
    id: ''
    isDisabled: false
    containerFields:
      inContainer: true
      isAnimated: true
      noMargin:
        top: false
        bottom: false
      noPadding:
        top: true
        bottom: false
      background:
        color: ''
        image: ''
        imageScreen: none
    text:
      leadIn: ''
      title: Our Impact
      titleTag: h2
      subTitle: Numbers that speak for themselves
      prose: ''
    stats:
      layout: grid
      items:
        - value: 10K+
          label: Active Users
          icon: users
          description: Developers building with our tools
        - value: 99.9%
          label: Uptime
          icon: activity
          description: Rock-solid reliability
        - value: 50M
          label: API Requests
          icon: zap
          description: Processed every month
        - value: 24/7
          label: Support
          icon: headphones
          description: Always here to help
```

## More Information

For complete documentation and live examples, visit:
https://nunjucks-components.netlify.app/library/stats/

