# Navigation Partial Component

A responsive navigation component with hamburger menu for mobile devices and scroll-based functionality.

## Data Structure

```yaml
mainMenu:
  - title: "Home"
    path: "/"
  - title: "About"
    path: "/about/"
  - title: "Blog"
    path: "/blog/"
  - title: "Contact"
    path: "/contact/"
```

## Properties

| Property | Type | Required | Description |
|----------|------|----------|-------------|
| `title` | String | Yes | Display text for the menu item |
| `path` | String | Yes | URL path for the menu link |

## HTML Output

```html
<nav>
  <ul class="main-menu">
    <li class="home">
      <a href="/">Home</a>
    </li>
    <li class="about">
      <a href="/about/">About</a>
    </li>
    <li class="blog">
      <a href="/blog/">Blog</a>
    </li>
    <li class="contact">
      <a href="/contact/">Contact</a>
    </li>
  </ul>
</nav>

<button class="hamburger-menu" aria-label="Toggle menu">
  <span></span>
  <span></span>
  <span></span>
</button>
```

## Usage Examples

### Basic Navigation

The navigation data are either generated by the `metalsmith-menu-plus` plugin or defined manually in a data JSONfile and then added to the metalsmith.metadata object as the `mainMenu` property. 

```json
{
  "mainMenu": [
    { "title": "Home", "path": "/" },
    { "title": "About", "path": "/about/" },
    { "title": "Blog", "path": "/blog/" },
    { "title": "Contact", "path": "/contact/" }
  ]
}
```

## Template Usage

```nunjucks
{% from "components/_partials/navigation/navigation.njk" import navigation %}
{{ navigation(mainMenu) }}
```

## Features

- **Responsive Design**: Desktop horizontal menu, mobile hamburger menu
- **Mobile Menu Toggle**: Hamburger button toggles mobile menu visibility
- **Auto Close**: Mobile menu closes when selecting a menu item
- **CSS Classes**: Each menu item gets a CSS class based on its path
- **Accessibility**: Proper ARIA labels for screen readers
