# Nunjucks Components Bundle v0.1.1

Complete collection of Nunjucks components for building modern websites with static site generators.

## Contents

This bundle includes:

- **38 Section Components:** accordion, artist-slider, audio-only, banner, blog-author, blurbs, calendar, cards-list, code, collection-links, collection-list, columns, commons, compound, flip-cards, footer, header, hero, hero-slider, icon-only, image-compare, image-grid, image-only, logos-list, lottie-only, maps, multi-media, podcast, pricing-table, search-only, slider, stats, steps, team-grid, testimonial, text-only, timeline, video-only
- **23 Partial Components:** audio, author-date, branding, breadcrumbs, button, collection-card, collection-pagination, ctas, dark-light-theme-switcher, flip-card, icon, image, language-switcher, lottie, manual-card, navigation, overlay, page-transitions, search, slider-pagination, text, text-link, video

## Prerequisites

Before installing components, create a `nunjucks-components.config.json` file in your project root:

```json
{
  "componentsBasePath": "lib/layouts/components",
  "sectionsDir": "sections",
  "partialsDir": "_partials"
}
```

Edit these values to match your project structure. This file is required for installation.

## Installation

### Installation Modes

The bundle installer supports two modes:

**1. Full Install (default)** - Installs all components:
```bash
# From your project root:
unzip nunjucks-components.zip
./nunjucks-components/install-all.sh
```

If you already have components installed, the script will prompt you to choose between:
- Install all components (adds new ones, updates existing)
- Update existing components only (skips new components)

**2. Update Mode** - Only updates components you already have:
```bash
./nunjucks-components/install-all.sh --update-only
# or use the short form:
./nunjucks-components/install-all.sh -u
```

This is perfect for:
- Updating a subset of components you're already using
- Getting bug fixes and improvements without adding new components
- Keeping your project lean with only the components you need

### Selective Installation

To install individual components from the bundle:

```bash
# From your project root:
./nunjucks-components/sections/hero/install.sh
# or for partials:
./nunjucks-components/partials/text/install.sh
```

## Documentation

For complete documentation and live examples, visit:
https://nunjucks-components.netlify.app/

## License

MIT License
